import tkinter as tk
from tkinter import messagebox
import pyads

# 创建 ADS 连接对象
plc = None

# TwinCAT 模式枚举
ADSSTATE = {
    "RUN": pyads.ADSSTATE_RESET,
    "CONFIG": pyads.ADSSTATE_RECONFIG,
}


def connect_to_plc():
    global plc
    ams_net_id = entry_ams_net_id.get()
    plc_ip = entry_plc_ip.get()
    plc_port = int(entry_plc_port.get())

    try:
        # 创建新的连接
        plc = pyads.Connection(ams_net_id, plc_port, plc_ip)
        plc.open()
        messagebox.showinfo("连接状态", "成功连接到 PLC")
        btn_connect.config(state=tk.DISABLED)  # 禁用连接按钮
        btn_disconnect.config(state=tk.NORMAL)  # 启用断开连接按钮
    except pyads.AdsError as e:
        messagebox.showerror("连接状态", f"连接失败: {e}")
    except ValueError:
        messagebox.showerror("输入错误", "请输入有效的端口号")

def disconnect_from_plc():
    global plc
    if plc is not None:
        try:
            plc.close()
            plc = None
            messagebox.showinfo("连接状态", "成功断开连接")
            btn_connect.config(state=tk.NORMAL)  # 启用连接按钮
            btn_disconnect.config(state=tk.DISABLED)  # 禁用断开连接按钮
        except pyads.AdsError as e:
            messagebox.showerror("断开连接错误", f"断开连接失败: {e}")


def change_twincat_mode(mode):
    if plc is None:
        messagebox.showerror("错误", "请先连接到 PLC")
        return

    try:
        # 获取模式对应的状态值
        state = plc.read_state()
        if state is None:
            messagebox.showerror("错误", "无效的模式")
            return

        # 切换 TwinCAT 模式
        print(ADSSTATE[mode])
        devicesate = 0
        plc.write_control(ADSSTATE[mode],devicesate,0,plc_datatype=pyads.PLCTYPE_INT)
        messagebox.showinfo("模式切换", f"成功切换到 {mode} 模式")
    except Exception as e:
        messagebox.showerror("模式切换错误", f"切换模式失败: {e}")

# 创建主窗口
root = tk.Tk()
root.title("TwinCAT状态切换")
root.geometry("300x300")

# AMS Net ID 输入
label_ams_net_id = tk.Label(root, text="AMS Net ID:")
label_ams_net_id.grid(row=0, column=0)
entry_ams_net_id = tk.Entry(root)
entry_ams_net_id.insert(0, "127.0.0.1.1.1")  # 设置默认值
entry_ams_net_id.grid(row=0, column=1)

# PLC IP 输入
label_plc_ip = tk.Label(root, text="PLC IP 地址:")
label_plc_ip.grid(row=1, column=0)
entry_plc_ip = tk.Entry(root)
entry_plc_ip.insert(0, "127.0.0.1")  # 设置默认值
entry_plc_ip.grid(row=1, column=1)

# PLC 端口输入
label_plc_port = tk.Label(root, text="PLC 端口:")
label_plc_port.grid(row=2, column=0)
entry_plc_port = tk.Entry(root)
entry_plc_port.insert(0, "10000")  # 设置默认值
entry_plc_port.grid(row=2, column=1)

# 连接按钮
btn_connect = tk.Button(root, text="连接到 PLC", command=connect_to_plc)
btn_connect.grid(row=4, column=0)

# 断开连接按钮
btn_disconnect = tk.Button(root, text="断开连接", command=disconnect_from_plc, state=tk.DISABLED)
btn_disconnect.grid(row=4, column=1)


# 模式切换按钮
label_mode = tk.Label(root, text="切换 TwinCAT 模式:")
label_mode.grid(row=5, column=0)

btn_run = tk.Button(root, text="切换到 RUN 模式", command=lambda: change_twincat_mode("RUN"))
btn_run.grid(row=6, column=0)



btn_config = tk.Button(root, text="切换到 CONFIG 模式", command=lambda: change_twincat_mode("CONFIG"))
btn_config.grid(row=6, column=1)

# 运行主循环
root.mainloop()


# 关闭 ADS 连接
if plc is not None:
    plc.close()
