﻿// MyFirstCppWinodwsPRG.cpp : 定义应用程序的入口点
//

#include "framework.h"
#include "MyFirstCppWinodwsPRG.h"

// 新增：第二步：自动链接msxml6.lib（告诉链接器去找这个库）
#pragma comment(lib, "msxml6.lib")

// ---------------------- 全局常量（新增：界面美化相关） ----------------------
const WCHAR g_szWindowClass[] = L"MyTwinCATToolClass";
const WCHAR g_szWindowTitle[] = L"TwinCAT Solution & XML Import Tool (v2.0)"; // 标题加版本号
const WCHAR g_szFontName[] = L"Microsoft YaHei"; // 统一使用微软雅黑字体
const int   g_nFontSize = 9;                     // 统一字体大小
const COLORREF g_clrBg = RGB(245, 247, 250);     // 柔和背景色（浅灰蓝）
const COLORREF g_clrGroupText = RGB(30, 144, 255); // 分组框标题色（蓝色）
const COLORREF g_clrBtnHover = RGB(220, 235, 250); // 按钮悬停背景色

// 全局字体句柄（所有控件共用，避免重复创建）
HFONT g_hGlobalFont = NULL;

// ---------------------- 函数前向声明（新增：界面辅助函数） ----------------------
ATOM                MyRegisterClass();
BOOL                InitInstance(int nCmdShow);
LRESULT CALLBACK    WndProc(HWND, UINT, WPARAM, LPARAM);
INT_PTR CALLBACK    About(HWND, UINT, WPARAM, LPARAM);
// 新增：创建全局字体
void                CreateGlobalFont();
// 新增：销毁全局字体
void                DestroyGlobalFont();
// 新增：设置控件字体（批量应用全局字体）
void                SetControlFont(HWND hCtrl);

// ---------------------- 模块1：控件创建（核心优化：分组布局+视觉美化） ----------------------
void CreateAllControls(HWND hParentWnd)
{
    // 1. 先创建分组框（按功能分区，用户一眼看清模块）
    // 1.1 IDE选择分组框
    HWND hGroupIDE = CreateWindowEx(
        0, L"STATIC", L" 1. IDE Selection ",
         WS_CHILD | WS_VISIBLE,
        15, 15, 560, 100, // 位置：左15，上15，宽560，高100
        hParentWnd, NULL, g_hInst, NULL
    );
    SetControlFont(hGroupIDE);
   

    // 1.2 解决方案管理分组框
    HWND hGroupSoln = CreateWindowEx(
        0, L"STATIC", L" 2. Solution Management ",
        WS_CHILD | WS_VISIBLE,
        15, 130, 560, 100, // 位置：紧接IDE分组下方（上130=15+100+15）
        hParentWnd, NULL, g_hInst, NULL
    );
    SetControlFont(hGroupSoln);
   

    // 1.3 XML导入分组框
    HWND hGroupXml = CreateWindowEx(
        0, L"STATIC", L" 3. Drive2 XML Import ",
         WS_CHILD | WS_VISIBLE,
        15, 245, 560, 100, // 位置：紧接解决方案分组下方（上245=130+100+15）
        hParentWnd, NULL, g_hInst, NULL
    );
    SetControlFont(hGroupXml);
    

    // 2. IDE选择分组内控件（相对于分组框定位，更规整）
    // 2.1 IDE下拉框（分组内左20，上25）
    g_hWndComboIDE = CreateWindowEx(
        0, L"COMBOBOX", L"",
        CBS_DROPDOWNLIST | WS_CHILD | WS_VISIBLE | WS_VSCROLL | CBS_HASSTRINGS,
        35, 40, 220, 200, // 35=15(分组左)+20，40=15(分组上)+25
        hParentWnd, (HMENU)IDC_COMBO_IDE, g_hInst, NULL
    );
    SetControlFont(g_hWndComboIDE);
    // 下拉框选项（保持原有）
    const WCHAR* arrIDEItems[] = { L"TcXaeShell (TwinCAT)", L"Visual Studio 2015", L"Visual Studio 2017", L"Visual Studio 2019" };
    for (int i = 0; i < _countof(arrIDEItems); i++)
    {
        SendMessage(g_hWndComboIDE, CB_ADDSTRING, 0, (LPARAM)arrIDEItems[i]);
    }
    // 默认选中并同步ProgID（保持原有修复逻辑）
    SendMessage(g_hWndComboIDE, CB_SETCURSEL, 0, 0);
    int nDefaultIndex = SendMessage(g_hWndComboIDE, CB_GETCURSEL, 0, 0);
    if (nDefaultIndex != CB_ERR)
    {
        int nTextLen = SendMessage(g_hWndComboIDE, CB_GETLBTEXTLEN, nDefaultIndex, 0);
        WCHAR* pwszIDEName = new WCHAR[nTextLen + 1];
        SendMessage(g_hWndComboIDE, CB_GETLBTEXT, nDefaultIndex, (LPARAM)pwszIDEName);
        if (wcscmp(pwszIDEName, L"TcXaeShell (TwinCAT)") == 0)
            g_bstrIDEProgID = L"TcXaeShell.DTE.15.0";
        else if (wcscmp(pwszIDEName, L"Visual Studio 2015") == 0)
            g_bstrIDEProgID = L"VisualStudio.DTE.14.0";
        else if (wcscmp(pwszIDEName, L"Visual Studio 2017") == 0)
            g_bstrIDEProgID = L"VisualStudio.DTE.15.0";
        else if (wcscmp(pwszIDEName, L"Visual Studio 2019") == 0)
            g_bstrIDEProgID = L"VisualStudio.DTE.16.0";
        delete[] pwszIDEName;
    }

    // 3. 解决方案分组内控件
    // 3.1 解决方案路径文本框（分组内左20，上25，宽320）
    g_hWndEditSolnPath = CreateWindowEx(
        WS_EX_CLIENTEDGE, L"EDIT", L"Select a .sln file...", // 提示文本更友好
        ES_AUTOHSCROLL | WS_CHILD | WS_VISIBLE | ES_LEFT | ES_READONLY,
        35, 155, 320, 28, // 35=15+20，155=130(分组上)+25
        hParentWnd, (HMENU)IDC_EDIT_SOLN_PATH, g_hInst, NULL
    );
    SetControlFont(g_hWndEditSolnPath);
   

    // 3.2 浏览解决方案按钮（文本框右侧，间距10）
    g_hWndBtnBrowseSoln = CreateWindowEx(
        0, L"BUTTON", L"Browse...",
        BS_PUSHBUTTON | WS_CHILD | WS_VISIBLE | BS_FLAT, // BS_FLAT：扁平化风格
        365, 155, 100, 28, // 365=35+320+10
        hParentWnd, (HMENU)IDC_BTN_BROWSE_SOLN, g_hInst, NULL
    );
    SetControlFont(g_hWndBtnBrowseSoln);

    // 3.3 打开解决方案按钮（分组内左20，上60）
    g_hWndBtnOpenSoln = CreateWindowEx(
        0, L"BUTTON", L"Open Solution",
        BS_PUSHBUTTON | WS_CHILD | WS_VISIBLE | BS_FLAT | WS_DISABLED,
        35, 190, 160, 32, // 190=130+60，高度32更易点击
        hParentWnd, (HMENU)IDC_BTN_OPEN_SOLN, g_hInst, NULL
    );
    SetControlFont(g_hWndBtnOpenSoln);

    // 3.4 关闭解决方案按钮（打开按钮右侧，间距10）
    g_hWndBtnCloseSoln = CreateWindowEx(
        0, L"BUTTON", L"Close Solution",
        BS_PUSHBUTTON | WS_CHILD | WS_VISIBLE | BS_FLAT | WS_DISABLED,
        205, 190, 160, 32, // 205=35+160+10
        hParentWnd, (HMENU)IDC_BTN_CLOSE_SOLN, g_hInst, NULL
    );
    SetControlFont(g_hWndBtnCloseSoln);

    // 3.5 激活TwinCAT按钮（关闭按钮右侧，间距10）
    g_hWndBtnActivateTC = CreateWindowEx(
        0, L"BUTTON", L"Activate TwinCAT",
        BS_PUSHBUTTON | WS_CHILD | WS_VISIBLE | BS_FLAT | WS_DISABLED,
        375, 190, 160, 32, // 375=205+160+10
        hParentWnd, (HMENU)IDC_BTN_ACTIVATE_TC, g_hInst, NULL
    );
    SetControlFont(g_hWndBtnActivateTC);

    // 4. XML导入分组内控件
    // 4.1 XML路径文本框（分组内左20，上25）
    g_hWndEditXmlPath = CreateWindowEx(
        WS_EX_CLIENTEDGE, L"EDIT", L"Select an XML file...", // 友好提示
        ES_AUTOHSCROLL | WS_CHILD | WS_VISIBLE | ES_LEFT | ES_READONLY,
        35, 270, 320, 28, // 35=15+20，270=245(分组上)+25
        hParentWnd, (HMENU)IDC_EDIT_XML_PATH, g_hInst, NULL
    );
    SetControlFont(g_hWndEditXmlPath);
   

    // 4.2 选择XML按钮（文本框右侧，间距10）
    g_hWndBtnSelectXml = CreateWindowEx(
        0, L"BUTTON", L"Select XML...",
        BS_PUSHBUTTON | WS_CHILD | WS_VISIBLE | BS_FLAT,
        365, 270, 100, 28, // 365=35+320+10
        hParentWnd, (HMENU)IDC_BTN_SELECT_XML, g_hInst, NULL
    );
    SetControlFont(g_hWndBtnSelectXml);

    // 4.3 导入XML按钮（分组内左20，上60）
    g_hWndBtnImportXml = CreateWindowEx(
        0, L"BUTTON", L"Import to Drive2",
        BS_PUSHBUTTON | WS_CHILD | WS_VISIBLE | BS_FLAT | WS_DISABLED,
        35, 305, 180, 32, // 305=245+60
        hParentWnd, (HMENU)IDC_BTN_IMPORT_XML, g_hInst, NULL
    );
    SetControlFont(g_hWndBtnImportXml);

    // 新增：4.4 手动保存配置按钮（导入按钮右侧，间距10）
    g_hWndBtnSaveConfig = CreateWindowEx(
        0, L"BUTTON", L"Save Config",
        BS_PUSHBUTTON | WS_CHILD | WS_VISIBLE | BS_FLAT | WS_DISABLED, // 默认禁用
        220, 305, 180, 32, // 220=35+180+10（与导入按钮并排）
        hParentWnd, (HMENU)IDC_BTN_SAVE_CONFIG, g_hInst, NULL
    );
    SetControlFont(g_hWndBtnSaveConfig);
}

// ---------------------- 模块2：通用文件对话框（保持原有，无需修改） ----------------------
BOOL ShowFileDialog(HWND hParentWnd, LPCWSTR lpFilter, LPCWSTR lpTitle, BSTR* pbstrSelectedPath)
{
    if (pbstrSelectedPath == NULL) return FALSE;

    OPENFILENAME ofn = { 0 };
    WCHAR szFilePath[MAX_PATH] = { 0 };

    ofn.lStructSize = sizeof(OPENFILENAME);
    ofn.hwndOwner = hParentWnd;
    ofn.lpstrFile = szFilePath;
    ofn.nMaxFile = MAX_PATH;
    ofn.lpstrFilter = lpFilter;
    ofn.nFilterIndex = 1;
    ofn.lpstrTitle = lpTitle;
    ofn.Flags = OFN_PATHMUSTEXIST | OFN_FILEMUSTEXIST | OFN_HIDEREADONLY | OFN_ENABLESIZING; // 允许对话框调整大小
    ofn.lpstrDefExt = lpFilter[0] == 'X' ? L"xml" : L"sln"; // 自动补全后缀

    if (GetOpenFileName(&ofn))
    {
        *pbstrSelectedPath = SysAllocString(szFilePath);
        return TRUE;
    }
    else
    {
        DWORD dwErr = CommDlgExtendedError();
        if (dwErr != 0)
        {
            WCHAR szErrMsg[256] = { 0 };
            swprintf_s(szErrMsg, L"File dialog error: 0x%08X", dwErr);
        }
        return FALSE;
    }
}

// ---------------------- 模块3：COM指针释放（保持原有，无需修改） ----------------------
void ReleaseComPointers()
{
    if (g_pTcSysMgr != NULL)
    {
        g_pTcSysMgr.Release();
        g_pTcSysMgr = NULL;
    }
    if (g_pDTEMgr != NULL)
    {
        g_pDTEMgr.Release();
        g_pDTEMgr = NULL;
    }
    // 修复：_bstr_t析构时会自动释放，无需手动赋值空字符串（赋值空串会多一次SysAllocString+SysFreeString，无错但冗余）
    // g_bstrSolnPath = L""; 
    // g_bstrXmlPath = L""; 
}

// ---------------------- 模块4：控件状态更新（新增：文本框提示色切换） ----------------------
void UpdateControlStates(BOOL bSolnOpened, BOOL bXmlSelected)
{
    // 1. 解决方案相关状态（保持原有逻辑）
    EnableWindow(g_hWndBtnOpenSoln, (g_bstrSolnPath.length() > 0) && !bSolnOpened);
    EnableWindow(g_hWndBtnCloseSoln, bSolnOpened);
    EnableWindow(g_hWndBtnActivateTC, bSolnOpened);

    // 2. XML导入相关状态（保持原有逻辑）
    EnableWindow(g_hWndBtnImportXml, bSolnOpened && bXmlSelected);

    // 保存配置
    EnableWindow(g_hWndBtnSaveConfig, bSolnOpened); // 只要解决方案打开就允许保存

    // 新增：文本框提示色切换（有内容时变黑，无内容时变灰）
    if (g_bstrSolnPath.length() > 0)
    {
        SetWindowText(g_hWndEditSolnPath, (LPCWSTR)g_bstrSolnPath);
       
    }
    else
    {
        SetWindowText(g_hWndEditSolnPath, L"Select a .sln file...");
        
    }

    if (g_bstrXmlPath.length() > 0)
    {
        SetWindowText(g_hWndEditXmlPath, (LPCWSTR)g_bstrXmlPath);
       
    }
    else
    {
        SetWindowText(g_hWndEditXmlPath, L"Select an XML file...");
      
    }
}

// ---------------------- 新增：界面辅助函数实现 ----------------------
// 创建全局字体（在WinMain中初始化）
void CreateGlobalFont()
{
    // 获取系统默认DPI，避免字体模糊
    HDC hdc = GetDC(NULL);
    int nDpi = GetDeviceCaps(hdc, LOGPIXELSY);
    ReleaseDC(NULL, hdc);
    // 计算字体大小（根据DPI适配）
    int nFontHeight = -MulDiv(g_nFontSize, nDpi, 72);
    // 创建字体（微软雅黑，无加粗，抗锯齿）
    g_hGlobalFont = CreateFont(
        nFontHeight, 0, 0, 0, FW_NORMAL,
        FALSE, FALSE, FALSE, DEFAULT_CHARSET,
        OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS,
        CLEARTYPE_QUALITY, DEFAULT_PITCH | FF_DONTCARE,
        g_szFontName
    );
}

// 销毁全局字体（在程序退出时）
void DestroyGlobalFont()
{
    if (g_hGlobalFont != NULL)
    {
        DeleteObject(g_hGlobalFont);
        g_hGlobalFont = NULL;
    }
}

// 给控件设置全局字体
void SetControlFont(HWND hCtrl)
{
    if (hCtrl != NULL && g_hGlobalFont != NULL)
    {
        SendMessage(hCtrl, WM_SETFONT, (WPARAM)g_hGlobalFont, TRUE);
    }
}

// ---------------------- 应用入口（WinMain：新增字体初始化） ----------------------
int APIENTRY wWinMain(_In_ HINSTANCE hInstance,
    _In_opt_ HINSTANCE hPrevInstance,
    _In_ LPWSTR    lpCmdLine,
    _In_ int       nCmdShow)
{
    UNREFERENCED_PARAMETER(hPrevInstance);
    UNREFERENCED_PARAMETER(lpCmdLine);

    // 1. 初始化COM环境（保持原有）
    HRESULT hr = CoInitializeEx(NULL, COINIT_APARTMENTTHREADED);
    if (FAILED(hr))
    {
        MessageBox(NULL, L"COM initialization failed! Program cannot run.", L"Fatal Error", MB_OK | MB_ICONERROR);
        return FALSE;
    }

    // 新增：2. 创建全局字体（在控件创建前初始化）
    CreateGlobalFont();

    // 3. 初始化全局实例句柄（保持原有）
    g_hInst = hInstance;

    // 4. 注册窗口类（保持原有）
    if (!MyRegisterClass())
    {
        MessageBox(NULL, L"Window class registration failed!", L"Fatal Error", MB_OK | MB_ICONERROR);
        DestroyGlobalFont(); // 新增：失败时销毁字体
        CoUninitialize();
        return FALSE;
    }

    // 5. 初始化实例（创建主窗口：调整窗口大小为600x380，适配新布局）
    if (!InitInstance(nCmdShow))
    {
        ReleaseComPointers();
        DestroyGlobalFont(); // 新增：失败时销毁字体
        CoUninitialize();
        return FALSE;
    }

    // 6. 消息循环（保持原有）
    HACCEL hAccelTable = LoadAccelerators(g_hInst, MAKEINTRESOURCE(IDC_MYFIRSTCPPWINODWSPRG));
    MSG msg;
    while (GetMessage(&msg, nullptr, 0, 0))
    {
        if (!TranslateAccelerator(msg.hwnd, hAccelTable, &msg))
        {
            TranslateMessage(&msg);
            DispatchMessage(&msg);
        }
    }

    // 7. 退出清理（新增：销毁全局字体）
    ReleaseComPointers();
    DestroyGlobalFont();
    CoUninitialize();
    return (int)msg.wParam;
}

// ---------------------- 新增：MSXML XML加载函数实现 ----------------------
// 加载XML文件，返回内容BSTR（成功返回S_OK，失败返回错误码）
HRESULT LoadXmlWithRawMSXML(const _bstr_t& bstrXmlPath, BSTR* pbstrXmlContent)
{
    if (!pbstrXmlContent) return E_POINTER;
    *pbstrXmlContent = NULL;

    IXMLDOMDocument2* pXmlDoc = NULL;
    IXMLDOMParseError* pParseErr = NULL;
    HRESULT hr = S_OK;

    try
    {
        // 1. 创建MSXML文档对象（原有逻辑不变）
        hr = CoCreateInstance(
            CLSID_DOMDocument60,
            NULL,
            CLSCTX_INPROC_SERVER,
            IID_IXMLDOMDocument2,
            (void**)&pXmlDoc
        );
        if (FAILED(hr) || !pXmlDoc) throw hr;

        // 2. 配置加载参数（原有逻辑不变）
        VARIANT_BOOL bAsync = VARIANT_FALSE;
        hr = pXmlDoc->put_async(bAsync);
        if (FAILED(hr)) throw hr;

        VARIANT_BOOL bValidate = VARIANT_FALSE;
        hr = pXmlDoc->put_validateOnParse(bValidate);
        if (FAILED(hr)) throw hr;

        // ---------------------- 修复：手动复制BSTR，避免使用_bstr_t内部指针 ----------------------
        VARIANT varXmlSource;
        VariantInit(&varXmlSource);
        varXmlSource.vt = VT_BSTR;
        // 关键：用SysAllocString复制_bstr_t的内容，生成新的BSTR
        varXmlSource.bstrVal = SysAllocString(bstrXmlPath);
        if (!varXmlSource.bstrVal) throw E_OUTOFMEMORY; // 检查分配是否成功

        // 3. 加载XML文件（原有逻辑不变）
        VARIANT_BOOL bLoaded = VARIANT_FALSE;
        hr = pXmlDoc->load(varXmlSource, &bLoaded);
        VariantClear(&varXmlSource); // 此时释放的是新分配的BSTR，不影响_bstr_t
        if (FAILED(hr) || !bLoaded) throw hr;

        // 4. 获取XML内容（原有逻辑不变）
        hr = pXmlDoc->get_xml(pbstrXmlContent);
        if (FAILED(hr) || !*pbstrXmlContent) throw hr;
    }
    catch (HRESULT err)
    {
        hr = err;
        // 新增：异常时释放可能未释放的BSTR/COM对象
        if (pParseErr) pParseErr->Release();
        if (pXmlDoc) pXmlDoc->Release();
    }

    // 释放COM对象（原有逻辑不变）
    if (pParseErr) pParseErr->Release();
    if (pXmlDoc) pXmlDoc->Release();
    return hr;
}

// ---------------------- 窗口类注册（修改：窗口背景色） ----------------------
ATOM MyRegisterClass()
{
    WNDCLASSEXW wcex;

    wcex.cbSize = sizeof(WNDCLASSEX);
    wcex.style = CS_HREDRAW | CS_VREDRAW;
    wcex.lpfnWndProc = WndProc;
    wcex.cbClsExtra = 0;
    wcex.cbWndExtra = 0;
    wcex.hInstance = g_hInst;
    wcex.hIcon = LoadIcon(g_hInst, MAKEINTRESOURCE(IDI_MYFIRSTCPPWINODWSPRG));
    wcex.hCursor = LoadCursor(nullptr, IDC_ARROW);
    // 修改：窗口背景色为柔和浅灰蓝
    wcex.hbrBackground = CreateSolidBrush(g_clrBg);
    wcex.lpszMenuName = MAKEINTRESOURCEW(IDC_MYFIRSTCPPWINODWSPRG);
    wcex.lpszClassName = g_szWindowClass;
    wcex.hIconSm = LoadIcon(wcex.hInstance, MAKEINTRESOURCE(IDI_SMALL));

    return RegisterClassExW(&wcex);
}

// ---------------------- 实例初始化（修改：窗口大小为600x380） ----------------------
BOOL InitInstance(int nCmdShow)
{
    // 创建主窗口：大小调整为600x380（适配3个分组框），禁用最大化
    g_hMainWnd = CreateWindowW(
        g_szWindowClass, g_szWindowTitle,
        WS_OVERLAPPEDWINDOW & ~WS_MAXIMIZEBOX & ~WS_THICKFRAME,
        CW_USEDEFAULT, 0, 600, 420, // 宽600，高380（原300不够）
        nullptr, nullptr, g_hInst, nullptr
    );

    if (!g_hMainWnd)
    {
        return FALSE;
    }

    ShowWindow(g_hMainWnd, nCmdShow);
    UpdateWindow(g_hMainWnd);

    return TRUE;
}

// ---------------------- 主窗口消息处理（新增：按钮悬停+文本框背景色） ----------------------
LRESULT CALLBACK WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
    switch (message)
    {
        // 1. 窗口创建：保持原有
    case WM_CREATE:
        CreateAllControls(hWnd);
        break;

        // 新增：2. 控件绘制消息（处理文本框背景色+按钮悬停）
    case WM_CTLCOLOREDIT:
    {
        HDC hdcEdit = (HDC)wParam;
        HWND hEdit = (HWND)lParam;
        // 文本框背景色改为白色（与浅灰背景区分）
        SetBkColor(hdcEdit, RGB(255, 255, 255));
        
        return (LRESULT)GetStockObject(WHITE_BRUSH); // 返回白色画刷
    }
    case WM_MOUSEMOVE:
    {
        // 按钮悬停检测：获取鼠标位置，判断是否在按钮上
        POINT pt;
        GetCursorPos(&pt);
        ScreenToClient(hWnd, &pt);

        // 要检测的按钮列表
        HWND arrBtns[] = { g_hWndBtnBrowseSoln, g_hWndBtnOpenSoln, g_hWndBtnCloseSoln,
                           g_hWndBtnActivateTC, g_hWndBtnSelectXml, g_hWndBtnImportXml };
        // 遍历按钮，设置悬停背景色
        for (int i = 0; i < _countof(arrBtns); i++)
        {
            if (arrBtns[i] == NULL || !IsWindowEnabled(arrBtns[i])) continue;

            RECT rcBtn;
            GetWindowRect(arrBtns[i], &rcBtn);
            ScreenToClient(hWnd, (LPPOINT)&rcBtn);
            ScreenToClient(hWnd, ((LPPOINT)&rcBtn) + 1);

            // 鼠标在按钮上：设置悬停色；否则恢复默认
            if (PtInRect(&rcBtn, pt))
            {
                SendMessage(arrBtns[i], BM_SETSTYLE, BS_PUSHBUTTON, TRUE); // 取消扁平化，突出
                SetBkColor(GetDC(arrBtns[i]), g_clrBtnHover);
            }
            else
            {
                SendMessage(arrBtns[i], BM_SETSTYLE, BS_FLAT, TRUE); // 恢复扁平化
                SetBkColor(GetDC(arrBtns[i]), GetSysColor(COLOR_BTNFACE));
            }
           // ReleaseDC(arrBtns[i], GetDC(arrBtns[i]));
        }
        break;
    }
    case WM_MOUSELEAVE:
    {
        // 鼠标离开窗口：所有按钮恢复默认样式
        HWND arrBtns[] = { g_hWndBtnBrowseSoln, g_hWndBtnOpenSoln, g_hWndBtnCloseSoln,
                           g_hWndBtnActivateTC, g_hWndBtnSelectXml, g_hWndBtnImportXml };
        for (int i = 0; i < _countof(arrBtns); i++)
        {
            if (arrBtns[i] == NULL) continue;
            SendMessage(arrBtns[i], BM_SETSTYLE, BS_FLAT, TRUE);
            SetBkColor(GetDC(arrBtns[i]), GetSysColor(COLOR_BTNFACE));
            ReleaseDC(arrBtns[i], GetDC(arrBtns[i]));
        }
        break;
    }

    // 3. 命令消息：保持原有业务逻辑（无需修改）
    case WM_COMMAND:
    {
        int wmId = LOWORD(wParam);
        int wmEvent = HIWORD(wParam);

        // 2.1 IDE选择下拉框变化
        if (wmId == IDC_COMBO_IDE && wmEvent == CBN_SELCHANGE)
        {
            int nSelIndex = SendMessage(g_hWndComboIDE, CB_GETCURSEL, 0, 0);
            if (nSelIndex == CB_ERR) break;

            int nTextLen = SendMessage(g_hWndComboIDE, CB_GETLBTEXTLEN, nSelIndex, 0);
            WCHAR* pwszIDEName = new WCHAR[nTextLen + 1];
            SendMessage(g_hWndComboIDE, CB_GETLBTEXT, nSelIndex, (LPARAM)pwszIDEName);

            if (wcscmp(pwszIDEName, L"TcXaeShell (TwinCAT)") == 0)
                g_bstrIDEProgID = L"TcXaeShell.DTE.15.0";
            else if (wcscmp(pwszIDEName, L"Visual Studio 2015") == 0)
                g_bstrIDEProgID = L"VisualStudio.DTE.14.0";
            else if (wcscmp(pwszIDEName, L"Visual Studio 2017") == 0)
                g_bstrIDEProgID = L"VisualStudio.DTE.15.0";
            else if (wcscmp(pwszIDEName, L"Visual Studio 2019") == 0)
                g_bstrIDEProgID = L"VisualStudio.DTE.16.0";

            delete[] pwszIDEName;
        }

        // 2.2 解决方案相关命令（浏览、打开、关闭）
        else if (wmId == IDC_BTN_BROWSE_SOLN && wmEvent == BN_CLICKED)
        {
            BSTR bstrSolnPath = NULL;
            if (ShowFileDialog(
                hWnd,
                SOLUTION_FILTER,
                L"Select TwinCAT Solution (*.sln)",
                &bstrSolnPath
            ))
            {
                g_bstrSolnPath = bstrSolnPath;
                SysFreeString(bstrSolnPath);
                BOOL bXmlSelected = (g_bstrXmlPath.length() > 0);
                UpdateControlStates(FALSE, bXmlSelected);
            }
        }

        else if (wmId == IDC_BTN_OPEN_SOLN && wmEvent == BN_CLICKED)
        {
            try
            {
                if (g_bstrIDEProgID.length() == 0 || g_bstrSolnPath.length() == 0)
                {
                    MessageBox(hWnd, L"Please select IDE and solution first!", L"Warning", MB_OK | MB_ICONWARNING);
                    break;
                }

                if (g_pDTEMgr != NULL)
                {
                    g_pDTEMgr.Release();
                    g_pDTEMgr = NULL;
                }

                HRESULT hr = g_pDTEMgr.CreateInstance((LPCWSTR)g_bstrIDEProgID);
                if (FAILED(hr))
                    throw _com_error(hr);

                WindowPtr pMainWindow;
                hr = g_pDTEMgr->get_MainWindow(&pMainWindow);
                if (SUCCEEDED(hr) && pMainWindow != NULL)
                    pMainWindow->put_Visible(VARIANT_TRUE);

                g_pDTEMgr->put_UserControl(VARIANT_TRUE);

                _SolutionPtr pSolution;
                hr = g_pDTEMgr->get_Solution(&pSolution);
                if (FAILED(hr) || pSolution == NULL)
                    throw _com_error(hr);

                hr = pSolution->Open(g_bstrSolnPath);
                if (FAILED(hr))
                    throw _com_error(hr);

                Sleep(3000);

                ProjectsPtr pProjects;
                hr = pSolution->get_Projects(&pProjects);
                if (FAILED(hr) || pProjects == NULL)
                    throw _com_error(hr);

                ProjectPtr pProject;
                hr = pProjects->Item(_variant_t((long)1), &pProject);
                if (FAILED(hr) || pProject == NULL)
                    throw _com_error(hr);

                IDispatchPtr pDisp;
                hr = pProject->get_Object(&pDisp);
                if (FAILED(hr) || pDisp == NULL)
                    throw _com_error(hr);

                hr = pDisp->QueryInterface(__uuidof(ITcSysManager), (void**)&g_pTcSysMgr);
                if (FAILED(hr) || g_pTcSysMgr == NULL)
                    throw _com_error(hr);

                MessageBox(hWnd, L"Solution opened successfully!", L"Success", MB_OK | MB_ICONINFORMATION);
                UpdateControlStates(TRUE, (g_bstrXmlPath.length() > 0));
            }
            catch (_com_error& e)
            {
                WCHAR szErrMsg[512] = { 0 };
                swprintf_s(
                    szErrMsg,
                    L"Open Solution Failed!\nError Code: 0x%08X\nMessage: %s",
                    e.Error(),
                    (LPWSTR)e.Description() ? (LPWSTR)e.Description() : L"No description"
                );
                MessageBox(hWnd, szErrMsg, L"Error", MB_OK | MB_ICONERROR);
                UpdateControlStates(FALSE, (g_bstrXmlPath.length() > 0));
            }
        }

        else if (wmId == IDC_BTN_CLOSE_SOLN && wmEvent == BN_CLICKED)
        {
            try
            {
                if (g_pDTEMgr == NULL || g_pTcSysMgr == NULL)
                {
                    MessageBox(hWnd, L"No solution is open!", L"Warning", MB_OK | MB_ICONWARNING);
                    break;
                }

                // 1. 关闭当前解决方案
                _SolutionPtr pSolution;
                HRESULT hr = g_pDTEMgr->get_Solution(&pSolution);
                if (SUCCEEDED(hr) && pSolution != NULL)
                {
                    pSolution->Close(VARIANT_FALSE); // 关闭解决方案
                }

                // 2. 关键：退出TwinCAT IDE进程（关闭空窗口）
                hr = g_pDTEMgr->Quit(); // 终止TcXaeShell进程
                if (FAILED(hr))
                    throw _com_error(hr);

            // 3. 释放COM指针
                ReleaseComPointers();

                UpdateControlStates(FALSE, FALSE);
                MessageBox(hWnd, L"Solution closed and TwinCAT IDE exited successfully!", L"Success", MB_OK | MB_ICONINFORMATION);
            }
            catch (_com_error& e)
            {
                WCHAR szErrMsg[512] = { 0 };
                swprintf_s(
                    szErrMsg,
                    L"Close Failed!\nError Code: 0x%08X\nMessage: %s",
                    e.Error(),
                    (LPWSTR)e.Description() ? (LPWSTR)e.Description() : L"No description");
                MessageBox(hWnd, szErrMsg, L"Error", MB_OK | MB_ICONERROR);
            }
        }

        // 2.3 TwinCAT激活命令
        else if (wmId == IDC_BTN_ACTIVATE_TC && wmEvent == BN_CLICKED)
        {
            try
            {
                if (g_pTcSysMgr == NULL)
                {
                    MessageBox(hWnd, L"Please open a solution first!", L"Warning", MB_OK | MB_ICONWARNING);
                    break;
                }

                HRESULT hr = g_pTcSysMgr->ActivateConfiguration();
                if (FAILED(hr))
                    throw _com_error(hr);

                hr = g_pTcSysMgr->StartRestartTwinCAT();
                if (FAILED(hr))
                    throw _com_error(hr);

                MessageBox(hWnd, L"TwinCAT activated and restarted successfully!", L"Success", MB_OK | MB_ICONINFORMATION);
            }
            catch (_com_error& e)
            {
                WCHAR szErrMsg[512] = { 0 };
                swprintf_s(
                    szErrMsg,
                    L"Activate TwinCAT Failed!\nError Code: 0x%08X\nMessage: %s",
                    e.Error(),
                    (LPWSTR)e.Description() ? (LPWSTR)e.Description() : L"No description"
                );
                MessageBox(hWnd, szErrMsg, L"Error", MB_OK | MB_ICONERROR);
            }
        }

        // 2.4 XML相关命令
        else if (wmId == IDC_BTN_SELECT_XML && wmEvent == BN_CLICKED)
        {
            BSTR bstrXmlPath = NULL;
            if (ShowFileDialog(
                hWnd,
                XML_FILTER,
                L"Select Drive2 Configuration XML (*.xml)",
                &bstrXmlPath
            ))
            {
                g_bstrXmlPath = bstrXmlPath;
                SysFreeString(bstrXmlPath);
                BOOL bSolnOpened = (g_pTcSysMgr != NULL);
                UpdateControlStates(bSolnOpened, TRUE);
            }
        }

        else if (wmId == IDC_BTN_IMPORT_XML && wmEvent == BN_CLICKED)
        {
            try
            {
                if (g_bstrXmlPath.length() == 0)
                    throw std::exception("Please select XML file first!");
                if (g_pTcSysMgr == NULL)
                    throw std::exception("Please open a solution first!");


                // 1. 调用原始MSXML加载函数，获取XML内容BSTR
                BSTR bstrXmlContent = NULL;
                HRESULT hr = LoadXmlWithRawMSXML(g_bstrXmlPath, &bstrXmlContent);
                if (FAILED(hr) || !bstrXmlContent)
                    throw _com_error(hr);


                _bstr_t bstrDrive2Path = L"TIID^Device 1 (EtherCAT)^Term 1 (EK1100)^Drive 2 (AX8108-0000-0107)";
                ITcSmTreeItemPtr pDrive2Item = NULL;
                 hr = g_pTcSysMgr->LookupTreeItem(bstrDrive2Path, &pDrive2Item);
                if (FAILED(hr) || pDrive2Item == NULL)
                    throw _com_error(hr);

                // 3. 导入XML（核心调用）
                hr = pDrive2Item->ConsumeXml(bstrXmlContent);
                SysFreeString(bstrXmlContent); // 仅释放一次，之后不再操作该指针
                bstrXmlContent = NULL; // 释放后置空，避免野指针
                if (FAILED(hr))
                {
                   
                    throw _com_error(hr);
                }

                MessageBox(hWnd, L"XML imported to Drive2 successfully!\nPlease activate TwinCAT to apply changes.", L"Success", MB_OK | MB_ICONINFORMATION);
                g_bstrXmlPath = L"";
                UpdateControlStates(TRUE, FALSE);
            }
            catch (std::exception& e)
            {
                WCHAR szErrMsg[512] = { 0 };
                MultiByteToWideChar(CP_ACP, 0, e.what(), -1, szErrMsg, 512);
                MessageBox(hWnd, szErrMsg, L"Import Failed", MB_OK | MB_ICONERROR);
            }
            catch (_com_error& e)
            {
                WCHAR szErrMsg[512] = { 0 };
                swprintf_s(
                    szErrMsg,
                    L"Import Failed!\nError Code: 0x%08X\nMessage: %s",
                    e.Error(),
                    (LPWSTR)e.Description() ? (LPWSTR)e.Description() : L"No description"
                );
                MessageBox(hWnd, szErrMsg, L"Error", MB_OK | MB_ICONERROR);
            }
        }

        else if (wmId == IDC_BTN_SAVE_CONFIG && wmEvent == BN_CLICKED)
        {
        try
        {
            if (g_pDTEMgr == NULL)
                throw std::exception("DTE manager is not initialized!");

            // 1. 获取解决方案指针
            _SolutionPtr pSolution;
            HRESULT hr = g_pDTEMgr->get_Solution(&pSolution);
            if (FAILED(hr) || !pSolution)
                throw _com_error(hr);

            // 2. 检查解决方案是否打开
            VARIANT_BOOL bIsOpen = VARIANT_FALSE;
            hr = pSolution->get_IsOpen(&bIsOpen);
            if (FAILED(hr) || !bIsOpen)
                throw std::exception("No solution is currently open!");

            // 3. 保存解决方案本身
            BSTR bstrSolnPath = NULL;
            hr = pSolution->get_FullName(&bstrSolnPath);
            if (FAILED(hr) || !bstrSolnPath)
            {
                SysFreeString(bstrSolnPath);
                throw _com_error(hr);
            }
            hr = pSolution->SaveAs(bstrSolnPath); // 解决方案保存
            if (FAILED(hr))
            {
                SysFreeString(bstrSolnPath);
                throw _com_error(hr);
            }

            // 4. 关键：遍历项目，获取每个项目的当前路径并保存
            ProjectsPtr pProjects;
            hr = pSolution->get_Projects(&pProjects);
            if (FAILED(hr) || !pProjects)
            {
                SysFreeString(bstrSolnPath);
                throw _com_error(hr);
            }

            long nProjectCount = 0;
            hr = pProjects->get_Count(&nProjectCount);
            if (FAILED(hr) || nProjectCount == 0)
            {
                SysFreeString(bstrSolnPath);
                throw std::exception("No projects found in solution.");
            }

            // 遍历所有项目（索引从1开始）
            for (long i = 1; i <= nProjectCount; i++)
            {
                ProjectPtr pProject;
                hr = pProjects->Item(_variant_t(i), &pProject);
                if (FAILED(hr) || !pProject)
                    throw _com_error(hr);

                // 4.1 获取项目当前完整路径（含文件名）
                BSTR bstrProjPath = NULL;
                hr = pProject->get_FullName(&bstrProjPath); // 项目路径（如xxx.tsproj）
                if (FAILED(hr) || !bstrProjPath)
                {
                    SysFreeString(bstrProjPath);
                    throw _com_error(hr);
                }

                // 4.2 传入当前路径调用Save，实现“保存”（覆盖原文件）
                hr = pProject->Save(bstrProjPath); // 核心：项目保存必须传路径
                if (FAILED(hr))
                {
                    SysFreeString(bstrProjPath);
                    SysFreeString(bstrSolnPath);
                    throw _com_error(hr);
                }

                SysFreeString(bstrProjPath); // 释放项目路径BSTR
            }

            // 5. 标记状态并提示
            pSolution->put_Saved(VARIANT_TRUE);
            SysFreeString(bstrSolnPath);

            MessageBox(hWnd,
                L"Solution and all projects saved successfully!",
                L"Save Success", MB_OK | MB_ICONINFORMATION);
        }
        catch (std::exception& e)
        {
            WCHAR szErrMsg[512] = { 0 };
            MultiByteToWideChar(CP_ACP, 0, e.what(), -1, szErrMsg, 512);
            MessageBox(hWnd, szErrMsg, L"Save Failed", MB_OK | MB_ICONERROR);
        }
        catch (_com_error& e)
        {
            WCHAR szErrMsg[512] = { 0 };
            swprintf_s(
                szErrMsg,
                L"Save Failed!\nError Code: 0x%08X\nMessage: %s",
                e.Error(),
                (LPWSTR)e.Description() ? (LPWSTR)e.Description() : L"No description"
            );
            MessageBox(hWnd, szErrMsg, L"Error", MB_OK | MB_ICONERROR);
        }
    }

        // 2.5 关于/退出命令
        else if (wmId == IDM_ABOUT)
        {
            DialogBox(g_hInst, MAKEINTRESOURCE(IDD_ABOUTBOX), hWnd, About);
        }
        else if (wmId == IDM_EXIT)
        {
            DestroyWindow(hWnd);
        }
        else
        {
            return DefWindowProc(hWnd, message, wParam, lParam);
        }
        break;
    }

    // 3. 窗口绘制：保持原有
    case WM_PAINT:
    {
        PAINTSTRUCT ps;
        HDC hdc = BeginPaint(hWnd, &ps);
        EndPaint(hWnd, &ps);
    }
    break;

    // 4. 窗口销毁：保持原有
    case WM_DESTROY:
        // 新增：销毁窗口背景画刷
        DeleteObject((HGDIOBJ)GetClassLongPtr(hWnd, GCLP_HBRBACKGROUND));
        ReleaseComPointers();
        PostQuitMessage(0);
        break;

        // 5. 默认消息处理
    default:
        return DefWindowProc(hWnd, message, wParam, lParam);
    }
    return 0;
}

// ---------------------- 关于对话框（优化：应用全局字体） ----------------------
INT_PTR CALLBACK About(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
    UNREFERENCED_PARAMETER(lParam);
    switch (message)
    {
    case WM_INITDIALOG:
        // 新增：给关于对话框的控件应用全局字体
        SetControlFont(GetDlgItem(hDlg, IDOK));
        SetControlFont(GetDlgItem(hDlg, IDC_STATIC));
        return (INT_PTR)TRUE;

    case WM_COMMAND:
        if (LOWORD(wParam) == IDOK || LOWORD(wParam) == IDCANCEL)
        {
            EndDialog(hDlg, LOWORD(wParam));
            return (INT_PTR)TRUE;
        }
        break;
    }
    return (INT_PTR)FALSE;
}